/*
PROGRAM FUZZYLOGIC UNTUK LOADCELL DAN MOTOR
NAMA  : FATAHILLAH IKRANEGARA
NIM   : 191020100067

SKRIPSI TEKNIK ELEKTRO 2023
*/


#include <Wire.h>
#include "Fuzzy.h"
#include "HX711.h"
#include <LiquidCrystal_I2C.h>
#include <Servo.h>

Servo myservo;  // create servo object to control a servo
LiquidCrystal_I2C lcd(0x27, 16, 2); // LCD pin SDA (A4) & pin SCL (A5)

// HX711 circuit wiring
const int LOADCELL_DOUT_PIN = 2;
const int LOADCELL_SCK_PIN = 3;

HX711 scale;

//Rule Base
float input;
float output;
float calibration_factor = 400; //225.5; //This value is obtained using the SparkFun_HX711_Calibration sketch
int pos = 0;    // Servo

//the relays connect to
#define PIN_RELAY 13

#define ON   0
#define OFF  1

//Instantiating a Fuzzy object
Fuzzy *fuzzy = new Fuzzy();

void setup()
{
  // Set the Serial output
  Serial.begin(9600);
//lcd.init();                      // initialize the lcd 
  lcd.begin();
  lcd.backlight();
  lcd.clear();
  
  scale.begin(LOADCELL_DOUT_PIN, LOADCELL_SCK_PIN);
  scale.set_scale(calibration_factor);       
  scale.tare();
  
  randomSeed(analogRead(0));
  myservo.attach(9);  // attaches the servo on pin 9 to the servo object
  
  pinMode(PIN_RELAY, OUTPUT);
  digitalWrite(PIN_RELAY, HIGH);

  // Instantiating a FuzzyInput object
  FuzzyInput *Loadcell = new FuzzyInput(1);
  // Instantiating a FuzzySet object
  FuzzySet *Light = new FuzzySet(100, 200, 300, 400);
  // Including the FuzzySet into FuzzyInput
  Loadcell->addFuzzySet(Light);
  // Instantiating a FuzzySet object
  FuzzySet *Average = new FuzzySet(400, 600, 800, 1000);
  // Including the FuzzySet into FuzzyInput
  Loadcell->addFuzzySet(Average);
  // Instantiating a FuzzySet object
  FuzzySet *Heavy = new FuzzySet(1000, 1500, 2000, 2500);
  // Including the FuzzySet into FuzzyInput
  Loadcell->addFuzzySet(Heavy);
  // Including the FuzzyInput into Fuzzy
  fuzzy->addFuzzyInput(Loadcell);

  // Instantiating a FuzzyOutput objects
  FuzzyOutput *speed = new FuzzyOutput(1);
  // Instantiating a FuzzySet object
  FuzzySet *Slow = new FuzzySet(0, 10, 20, 30);
  // Including the FuzzySet into FuzzyOutput
  speed->addFuzzySet(Slow);
  // Instantiating a FuzzySet object
  FuzzySet *Medium = new FuzzySet(0, 20, 40, 60);
  // Including the FuzzySet into FuzzyOutput
  speed->addFuzzySet(Medium);
  // Instantiating a FuzzySet object
  FuzzySet *Fast = new FuzzySet(0, 60, 90, 120);
  // Including the FuzzySet into FuzzyOutput
  speed->addFuzzySet(Fast);
  // Including the FuzzyOutput into Fuzzy
  fuzzy->addFuzzyOutput(speed);

  // Building FuzzyRule "IF loadcell = ringan THEN speed = slow"
  // Instantiating a FuzzyRuleAntecedent objects
  FuzzyRuleAntecedent *ifLoadcellLight = new FuzzyRuleAntecedent();
  // Creating a FuzzyRuleAntecedent with just a single FuzzySet
  ifLoadcellLight->joinSingle(Light);
  // Instantiating a FuzzyRuleConsequent objects
  FuzzyRuleConsequent *thenSpeedSlow = new FuzzyRuleConsequent();
  // Including a FuzzySet to this FuzzyRuleConsequent
  thenSpeedSlow->addOutput(Slow);
  // Instantiating a FuzzyRule objects
  FuzzyRule *fuzzyRule01 = new FuzzyRule(1, ifLoadcellLight, thenSpeedSlow);
  // Including the FuzzyRule into Fuzzy
  fuzzy->addFuzzyRule(fuzzyRule01);

  // Building FuzzyRule "IF loadcell = sedang THEN speed = average"
  // Instantiating a FuzzyRuleAntecedent objects
  FuzzyRuleAntecedent *ifLoadcellAverage = new FuzzyRuleAntecedent();
  // Creating a FuzzyRuleAntecedent with just a single FuzzySet
  ifLoadcellAverage->joinSingle(Average);
  // Instantiating a FuzzyRuleConsequent objects
  FuzzyRuleConsequent *thenSpeedMedium = new FuzzyRuleConsequent();
  // Including a FuzzySet to this FuzzyRuleConsequent
  thenSpeedMedium->addOutput(Medium);
  // Instantiating a FuzzyRule objects
  FuzzyRule *fuzzyRule02 = new FuzzyRule(2, ifLoadcellAverage, thenSpeedMedium);
  // Including the FuzzyRule into Fuzzy
  fuzzy->addFuzzyRule(fuzzyRule02);

  // Building FuzzyRule "IF loadcell = berat THEN speed = high"
  // Instantiating a FuzzyRuleAntecedent objects
  FuzzyRuleAntecedent *ifLoadcellHeavy = new FuzzyRuleAntecedent();
  // Creating a FuzzyRuleAntecedent with just a single FuzzySet
  ifLoadcellHeavy->joinSingle(Heavy);
  // Instantiating a FuzzyRuleConsequent objects
  FuzzyRuleConsequent *thenSpeedFast = new FuzzyRuleConsequent();
  // Including a FuzzySet to this FuzzyRuleConsequent
  thenSpeedFast->addOutput(Fast);
  // Instantiating a FuzzyRule objects
  FuzzyRule *fuzzyRule03 = new FuzzyRule(3, ifLoadcellHeavy, thenSpeedFast);
  // Including the FuzzyRule into Fuzzy
  fuzzy->addFuzzyRule(fuzzyRule03);
  
}
void loop()
{
  // Getting a random value
  int input = (scale.get_units());          // merupakan "nilai berat"
  scale.set_scale(calibration_factor);
  // Printing something
  lcd.setCursor(0,0);
  lcd.print("Beban:");
  lcd.print(input);
  lcd.print(" gram");
  delay(100);

  pos = 90;
  myservo.write(pos);

  // Getting a random value
//  int input = random(100, 2500);
  // Printing something
  Serial.println("\n\n\nEntrance: ");
  Serial.print("\t\t\tBeban: ");
  Serial.println(input);
  // Set the random value as an input
  fuzzy->setInput(1, input);
  // Running the Fuzzification
  fuzzy->fuzzify();
  // Running the Defuzzification
  float output = fuzzy->defuzzify(1);
  // Printing something
  Serial.println("Hasil: ");
  Serial.print("\t\t\tSpeed: ");
  Serial.println(output);
  // wait 12 seconds
  delay(5000);

  // Loadcell Light
  if (input >=100  and input <= 400) {
    scale.set_scale(calibration_factor);
    lcd.setCursor(0,1);
    lcd.print("MOTOR ON 30S");
    delay(1000);
    digitalWrite(PIN_RELAY, LOW); //turn on RELAY_1
    delay(2000);
    myservo.write(35);
    delay(30000); // berjalan 30s
    myservo.write(90);
    delay(500);
    digitalWrite(PIN_RELAY, HIGH); //turn off RELAY_1
    delay(100);
    scale.tare();
    scale.set_scale(calibration_factor);  
    }

  // Loadcell Average
  else if  (input >=350  and input <= 700) {
    lcd.setCursor(0,1);
    lcd.print("MOTOR ON 60S");
    delay(1000);
    digitalWrite(PIN_RELAY, LOW); //turn on RELAY_1
    delay(2000);
    myservo.write(35);
    delay(60000); // berjalan 60s
    myservo.write(90);
    delay(500);
    digitalWrite(PIN_RELAY, HIGH); //turn off RELAY_1
    delay(1000);
    scale.tare();
    scale.set_scale(calibration_factor);
    }

// Loadcell Heavy
  else if  (input >=650  and input <= 1000) {
    lcd.setCursor(0,1);
    lcd.print("MOTOR ON 90S");
    delay(1000);
    digitalWrite(PIN_RELAY, LOW); //turn on RELAY_1
    delay(2000);
    myservo.write(35);
    delay(60000); // berjalan 90s
    myservo.write(90);
    delay(500);
    digitalWrite(PIN_RELAY, HIGH); //turn off RELAY_1
    delay(1000);
    scale.tare();
    scale.set_scale(calibration_factor);
    }
    
  // Loadcell >Heavy
  else if (input >= 1000) {
    lcd.setCursor(0,1);
    lcd.print("overload");
    delay(1000);
    scale.tare();
    scale.set_scale(calibration_factor);
  }}
